"use client"

import { Text } from "@/components/typeography/text";
import { Button } from "@/components/ui/button";
import { useApplicationWorkflow } from "@/hooks/use-application-workflow";
import { cn } from "@/lib/utils";
import { ComponentWithClassName } from "@/types/utils";
import { Plus } from "lucide-react";

export function WorkflowButtonInvite({
  className,
  disabled = false,
}: ComponentWithClassName<{ disabled?: boolean }>) {
  const { setWorkflow } = useApplicationWorkflow()

  return (
    <Button
      disabled={disabled}
      variant="secondary"
      size={"lg"}
      onClick={() => setWorkflow({
        __tag: "INVITE_NEW_MEMBER",
      })}
      className={cn(
        className
      )}
      aria-label={`Open dialog to invite new members to access the trip planner preview.`}
    >
      <div
        className={"w-full h-full flex flex-row gap-2 justify-center items-center text-muted-foreground"}
      >
        <Plus className="size-3" />
        <Text variant={"p"} affects={"small"} override={"removeMarginsAndLeading"}>
          Invite Member
        </Text>
      </div>
    </Button>
  )
}

